import React, { useMemo } from 'react';
import "./briskNightTheme.css";

interface BriskNightThemeProps {
  mode?: "light" | "dusky"; // 'light' for dusk/sunset, 'dusky' for deep night/vaporwave
}

const BriskNightTheme: React.FC<BriskNightThemeProps> = ({ mode = "light" }) => {
  const headerImages = useMemo(() => [
    "/images/Elements/skiesheader.png"
  ], []);

  //const backgroundBorderImages = useMemo(() => [
    //"/images/RoyaltyFree/wsteria skies spencerwing.jpg", // If it has a dusk/night feel
    //"/images/RoyaltyFree/forest clouds 6.jpg", // For a moody sky border
   // "/images/RoyaltyFree/dance neon violet ethereal hulkiokantabak.jpg",
   // "/images/RoyaltyFree/spiderweb beaded glisten deep saturated purple bg simedblack.jpg"
  //], []);

  const mainBackgroundImageHints = useMemo(() => [
    "/images/Elements/skiesbg.png"
  ], []);

  const sidebarImages = useMemo(() => [
    "/images/Elements/skiessidebar.png"
  ], []);

  const frameDecorationImages = useMemo(() => [
    // Images for night sky frames: stars, sparkles, fireflies, neon lines, clouds
    //"/images/RoyaltyFree/dance neon violet ethereal hulkiokantabak.jpg",
    //"/images/RoyaltyFree/neon jellyfish nika_akin.jpg",
    //"/images/RoyaltyFree/spiderweb beaded glisten deep saturated purple bg simedblack.jpg",
    // Placeholder for specific frame assets like star patterns or firefly overlays
    // "/images/RoyaltyFree/found/star_constellation_border.png",
    // "/images/RoyaltyFree/found/firefly_animated_overlay.gif", // If GIFs are supported
    // "/images/RoyaltyFree/found/gold_haze_frame.png"
  ], []);

  const selectedHeaderImage = useMemo(() => headerImages[0], [headerImages]);
  const selectedMainBackgroundImageHint = useMemo(() => mainBackgroundImageHints[0], [mainBackgroundImageHints]);
  const selectedSidebarImage = useMemo(() => sidebarImages[0], [sidebarImages]);
  const selectedFrameDecorationImage = useMemo(() => frameDecorationImages[Math.floor(Math.random() * frameDecorationImages.length)], [frameDecorationImages]);
  const selectedFrameFullBorderImage = useMemo(() => frameDecorationImages[Math.floor(Math.random() * frameDecorationImages.length)], [frameDecorationImages]);

  const navItems = [
    { name: "Cosmos A", path: "/annepie/cosmosA" },
    { name: "Cosmos B", path: "/annepie/cosmosB" },
    { name: "Cosmos C", path: "/annepie/cosmosC" },
    { name: "Cosmos D", path: "/annepie/cosmosD" },
    { name: "Cosmos E", path: "/annepie/cosmosE" },
  ];

  return (
    <div
      className={`nightSky-theme-container ${mode}`}
      style={{ backgroundImage: `url(${mainBackgroundImageHints[0]})` }}
    >
      <header className="nightSky-header">
        <img src={selectedHeaderImage} alt="Night Sky Header" className="nightSky-header-image" />
        <div className="nightSky-header-overlay">
          <h1 className="nightSky-site-title">Annepi.com</h1>
          <nav className="nightSky-navigation">
            {navItems.map(item => (
              <a key={item.name} href={item.path} className="nightSky-nav-link">{item.name}</a>
            ))}
          </nav>
        </div>
      </header>

      <div 
        className="nightSky-body-wrapper"
        style={{ backgroundImage: `url(${selectedFrameFullBorderImage})` }}
      >
        <div className="nightSky-content">
          <aside
            className="nightSky-sidebar"
            style={{ backgroundImage: `url(${selectedSidebarImage})` }}
          >
            <p><strong>Night Thoughts:</strong></p>
            <ul className="nightSky-sidebar-path">
              <li><a href="#stars">Star Gazing</a></li>
              <li><a href="#dreams">Dream Logic</a></li>
              <li><a href="#dusk">Dusk Till Dawn</a></li>
            </ul>
            <p>The universe is listening...</p>
          </aside>

          <main className="nightSky-main">
            <h2>Painted Skies, Open Roads</h2>
            <p>A journey through dusk, starlight, and the freedom of the night.</p>

            <div className="nightSky-decorative-frame nightSky-video-frame-example">
              <div className="nightSky-frame-decoration-top" style={{backgroundImage: `url(${selectedFrameDecorationImage})`}}></div>
              <div className="nightSky-frame-content">
                <p>Content with ethereal top/bottom frame</p>
              </div>
              <div className="nightSky-frame-decoration-bottom" style={{backgroundImage: `url(${selectedFrameDecorationImage})`}}></div>
            </div>

            <div 
              className="nightSky-decorative-frame nightSky-full-border-frame-example"
              style={{ backgroundImage: `url(${selectedFrameFullBorderImage})` }}
            >
              <div className="nightSky-frame-content">
                <p>Stream of consciousness in a golden haze</p>
              </div>
            </div>

            <div className="nightSky-decorative-frame nightSky-circular-frame-example">
                <div className="nightSky-frame-content nightSky-circular-content">
                    <p>Star</p> 
                </div>
            </div>
          </main>
        </div>
      </div>
    </div>
  );
};

export default BriskNightTheme; 